from random import random
from django.core.management.base import BaseCommand
from django import db
from django.contrib.gis.geos import Point
from kozanorama.core.models import Cinema, Psitopoleio

ranges = { 1: (23.66000, 37.96000, 23.69667, 37.98333),
           2: (23.69667, 37.96000, 23.73333, 37.98333),
           3: (23.73333, 37.96000, 23.77000, 38.00667),
           4: (23.66000, 37.98333, 23.69667, 38.03000),
           5: (23.69667, 37.98333, 23.73333, 38.00667),
           6: (23.69667, 38.00667, 23.73333, 38.03000),
           7: (23.73333, 38.00667, 23.77000, 38.03000),}

model_classes = (Cinema, Psitopoleio,)

class Command(BaseCommand):
    args = ''
    help = """Gives random positions on Cinema and Psitopoleio
              objects"""

    def handle(self, *args, **options):
        for model_class in model_classes:
            for item in model_class.objects.all():
                region_id = item.region.id
                x0, y0, x1, y1 = ranges[region_id]
                dx, dy = x1-x0, y1-y0
                item.ref_point = Point(x0+random()*dx, y0+random()*dy,
                                       srid=4326)
                item.save()
