#from django.db import models
#GIS: use django.contrib.gis.db instead of
#     django.db
from django.contrib.gis.db import models
from django.contrib.gis.measure import D
from django.contrib.gis.geos import Point

class Region(models.Model):
    name = models.CharField(max_length=128)
    def __unicode__(self):
        return self.name


class Film(models.Model):
    name = models.CharField(max_length=128)
    def __unicode__(self):
        return self.name


class Cinema(models.Model):
    name = models.CharField(max_length=128)
    region = models.ForeignKey(Region)
    film = models.ForeignKey(Film)
    #GIS: Add point geospatial field...
    ref_point = models.PointField(null=True, blank=True)
    #GIS: Replace the default manager with GeoManager to
    #     enable geospatial queries
    objects = models.GeoManager()
    #GIS: add these methods for ajax table
    def kontina_psitopoleia_count(self):
        return Psitopoleio.objects.filter(ref_point__distance_lte=(self.ref_point, D(km=2.5))).count()
    def kontinotero_psitopoleio(self):
        return Psitopoleio.objects.distance(self.ref_point).order_by('distance')[0]
    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name = "Cinemas"
        verbose_name_plural = "Cinemades"


class Psitopoleio(models.Model):
    name = models.CharField(max_length=128)
    rating = models.IntegerField(default=2)
    region = models.ForeignKey(Region)
    #Add point geospatial field...
    ref_point = models.PointField(null=True, blank=True)
    #GIS: Replace the default manager with GeoManager to
    #     enable geospatial queries
    objects = models.GeoManager()
    def asterakia(self):
        return self.rating*'* '
    #GIS: add these methods for ajax table
    def kontina_cinema_count(self):
        return Cinema.objects.filter(ref_point__distance_lte=(self.ref_point, D(km=2.5))).count()
    def kontinotero_cinema(self):
        return Cinema.objects.distance(self.ref_point).order_by('distance')[0]
    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name = "Psitopoleio"
        verbose_name_plural = "Psitopoleia"

