from django.http import Http404
from django.shortcuts import render_to_response, get_object_or_404
from django.views.generic import list_detail
#GIS specific modules
from django.contrib.gis.measure import D
from django.contrib.gis.shortcuts import render_to_kml
from django.contrib.gis.geos import Polygon, Point

from kozanorama.core.models import *
from kozanorama.core.decorators import *


def cinema_detail(request, *args, **kwargs):
    cinema = get_object_or_404(Cinema, pk=kwargs["object_id"])
#    pshtopoleia_sthn_perioxh = \
#        Psitopoleio.objects.filter(region__id=cinema.region.id).order_by('-rating')
#GIS: Filter psitopoleia results by maximum distance from cinema=2.5km, 
#     Then sort results by distance from cinema.
    pshtopoleia_sthn_perioxh = \
        Psitopoleio.objects.filter(ref_point__distance_lte=(cinema.ref_point, 
                                   D(km=2.5))).distance(cinema.ref_point).order_by('distance')
    kwargs["request"] = request
    kwargs["template_name"] = "cinema_detail.html"
    kwargs["extra_context"] = {"pshtopoleia_sthn_perioxh":pshtopoleia_sthn_perioxh, }
    return list_detail.object_detail(*args, **kwargs)


def psitopoleio_detail(request, *args, **kwargs):
    psitopoleio = get_object_or_404(Psitopoleio, pk=kwargs["object_id"])
#    cinemades_sthn_perioxh = \
#        Cinema.objects.filter(region__id=psitopoleio.region.id).order_by('film__name')
#GIS: Filter cinema results by maximum distance from psitopoleio=2.5km, 
#     Then sort results by distance from psitopoleio.
    cinemades_sthn_perioxh = \
        Cinema.objects.filter(ref_point__distance_lte=(psitopoleio.ref_point, 
                                   D(km=2.5))).distance(psitopoleio.ref_point).order_by('distance')
    kwargs["request"] = request
    kwargs["template_name"] = "psitopoleio_detail.html"
    kwargs["extra_context"] = {"cinemades_sthn_perioxh":cinemades_sthn_perioxh, }
    return list_detail.object_detail(*args, **kwargs)


#@sort_by
#@filter_by
#def cinema_list(request, queryset, *args, **kwargs):
#    kwargs["template_name"] = "cinema_list.html"
#    queryset = queryset
#    return list_detail.object_list(request,queryset=queryset, *args, **kwargs )


#@sort_by
#@filter_by
#def psitopoleio_list(request, queryset, *args, **kwargs):
#    kwargs["template_name"] = "psitopoleio_list.html"
#    queryset = queryset
#    return list_detail.object_list(request,queryset=queryset, *args, **kwargs )


def object_list_ajax(request, queryset, *args, **kwargs):
    if request.GET.__contains__('bound_box'):
        minx,miny,maxx,maxy = [float(x) for x in request.GET['bound_box'].split(',')]
        geom=Polygon(((minx,miny),(minx,maxy),(maxx,maxy),(maxx,miny),(minx,miny)),srid=4326)
        center=Point(0.5*(minx+maxx), 0.5*(miny+maxy), srid=4326)
    else:
        raise Http404
#GIS:  Check if point is inside the map bounding box
    queryset = queryset.filter(ref_point__bboverlaps=geom).distance(center).order_by('distance')
    return list_detail.object_list(request,queryset=queryset, *args, **kwargs )


#GIS: return map display data as KML
#     Psitopoleio, Cinema in different layer, get the GET parameter to
#     return the desired model data.
def kml(request):
    model_classes = {'psitopoleio': Psitopoleio, 'cinema': Cinema,}
    try:
        if request.GET.__contains__('model'):
            model_class = model_classes[request.GET['model']]
        else:
            raise
        queryres = model_class.objects.all()
    except Exception, e:
        raise Http404
    for arow in queryres:
        if arow.ref_point: 
            arow.kml = arow.ref_point.kml
    return render_to_kml("placemarks.kml", {'places': queryres})
