Object.extend = function(destination, source) {
    for (var property in source)
        destination[property] = source[property];
    return destination;
};

var map = null;
function get_attribute(afeature, attrib)
{
    if(!afeature.cluster)
        return afeature.attributes[attrib];
    else
        return afeature.cluster[0].attributes[attrib];
}

function CreateLayer(AName, ObjectName){
    var params={request: 'GetFeature'};
    params['srs'] = 'EPSG:4326';
    params['version'] = '1.0.0';
    params['service'] = 'WFS';
    params['format'] = 'WFS';
    params['model'] = ObjectName;
    var labelvalue = "";
    var labeling_opts = {
            label : labelvalue, fontColor: "#704060",
            fontSize: "10px", fontFamily: "Verdana, Arial",
            fontWeight: "bold", labelAlign: "cm" 
    };
    var general_opts = {
            externalGraphic: MEDIA_URL+markers_icons[ObjectName],
            graphicWidth: 32, graphicHeight:32, graphicXOffset:-15,
            graphicYOffset: -34, fillOpacity: 1
    };
    general_opts = Object.extend(general_opts, labeling_opts);
    AURL = ROOT_URL+"kml/";
    var alayer = new OpenLayers.Layer.Vector(AName,
    {
        strategies: [
                     new OpenLayers.Strategy.Fixed(),
                     new OpenLayers.Strategy.Cluster({distance: 20,
                     threshold: 2})
                     ],
        protocol: new OpenLayers.Protocol.HTTP({
                        url: AURL,
                        format: new OpenLayers.Format.KML(),
                        params: params}),
        projection: new OpenLayers.Projection("EPSG:4326"),
        formatOptions: { extractAttributes:true },
        styleMap: new OpenLayers.StyleMap({
            "default": new OpenLayers.Style(
                  OpenLayers.Util.applyDefaults(general_opts,
                        OpenLayers.Feature.Vector.style["default"]),
                        {context: {aname: function(feature) { return get_attribute(feature, "name"); }}})
        })
    } );
    var defaultStyle = alayer.styleMap.styles["default"].defaultStyle;
    defaultStyle["label"]="${aname}";
    alayer.styleMap.styles["default"].setDefaultStyle(defaultStyle);
    return alayer;
}
var psitopoleia = CreateLayer("Ψητοπωλεία", "psitopoleio");
var cinemades = CreateLayer("Σινεμάδες", "cinema");
var categories = [psitopoleia, cinemades];
function init() {
    var options = {
        'units' :   "m",
        'numZoomLevels' :   15,
        'sphericalMercator': true,
        'maxExtent': bounds,
        'projection'    :   new OpenLayers.Projection("EPSG:9009313"),
        'displayProjection':    new OpenLayers.Projection("EPSG:4326")
    };
    map = new OpenLayers.Map('map', options);
    map.addControl(new OpenLayers.Control.ScaleLine());
    var ANavToolBar = new OpenLayers.Control.NavToolbar();
        map.addControl(ANavToolBar);
    $("div.olControlNavToolbar").css("top","14px");
    $("div.olControlNavToolbar").css("left","11px");
    pzb = new OpenLayers.Control.PanZoomBar();
    pzb.zoomWorldIcon = false;
    map.addControl(pzb);
    map.addControl(new OpenLayers.Control.MousePosition());
    map.addControl(new OpenLayers.Control.OverviewMap());
    ls = new OpenLayers.Control.LayerSwitcher();
    map.addControl(ls);
    map.addLayers(base_layers);
    map.addLayers(categories);
    map.zoomToExtent(bounds);
    ajax_fetch();
    map.events.register("move", map, ajax_fetch);
    ls.baseLbl.innerHTML='Base layers';
    ls.dataLbl.innerHTML='Data layers';
}

function ajax_fetch(evt) { 
   $.get(AJAX_URL, {
        bound_box: map.getExtent().transform(new OpenLayers.Projection("EPSG:900913"), new OpenLayers.Projection("EPSG:4326")).toBBOX(7)
   }, function(data){
       $('#list').html(data);
   });
}
