from django.conf.urls.defaults import *
from django.conf import settings
from kozanorama.core.models import *
from kozanorama.core import views

from django.contrib import admin
admin.autodiscover()

cinemas = {'queryset': Cinema.objects.all(),
            'template_object_name': 'cinema',}
psitopoleia = {'queryset': Psitopoleio.objects.all(),
            'template_object_name': 'psitopoleio',}

urlpatterns = patterns('',
    (r'^$', 'django.views.generic.simple.direct_to_template', {'template': 'index.html'}, 'index'), 
#    (r'^cinemas/$',
#     views.cinema_list, cinemas, 'cinema_list'),
    (r'^cinemas/$', 'django.views.generic.simple.direct_to_template', {'template': 'cinema_list.html'}, 'cinema_list'), 
    (r'^cinemas_ajax/$',
     views.object_list_ajax, dict(cinemas.items()+[['template_name', 'cinema_list_ajax.html'],]), 
     'cinema_list_ajax'),
    (r'^psitopoleia_ajax/$',
     views.object_list_ajax, dict(psitopoleia.items()+[['template_name', 'psitopoleio_list_ajax.html'],]), 
     'psitopoleia_list_ajax'),
#    (r'^psitopoleia/$',
#     views.psitopoleio_list, psitopoleia, 'psitopoleio_list'),
    (r'^psitopoleia/$', 'django.views.generic.simple.direct_to_template', {'template': 'psitopoleio_list.html'}, 'psitopoleio_list'), 
    (r'^cinemas/(?P<object_id>\d+)/$',
     views.cinema_detail, cinemas, 'cinema_detail'),
    (r'^psitopoleia/(?P<object_id>\d+)/$',
     views.psitopoleio_detail, psitopoleia, 'psitopoleio_detail'),
#GIS: add a kml address to get geographical data for map display
    (r'^kml/$', 
     views.kml, {}, 'kml'),

    (r'^admin/', include(admin.site.urls)),
)

urlpatterns += patterns('',
    (r'^site_media/(?P<path>.*)$', 'django.views.static.serve',
     {'document_root': settings.MEDIA_ROOT}),
)
