# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models

class Migration(SchemaMigration):
    
    def forwards(self, orm):
        
        # Adding model 'Region'
        db.create_table('core_region', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=128)),
        ))
        db.send_create_signal('core', ['Region'])

        # Adding model 'Film'
        db.create_table('core_film', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=128)),
        ))
        db.send_create_signal('core', ['Film'])

        # Adding model 'Cinema'
        db.create_table('core_cinema', (
            ('region', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Region'])),
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('film', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Film'])),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=128)),
        ))
        db.send_create_signal('core', ['Cinema'])

        # Adding model 'Psitopoleio'
        db.create_table('core_psitopoleio', (
            ('rating', self.gf('django.db.models.fields.IntegerField')(default=2)),
            ('region', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Region'])),
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=128)),
        ))
        db.send_create_signal('core', ['Psitopoleio'])
    
    
    def backwards(self, orm):
        
        # Deleting model 'Region'
        db.delete_table('core_region')

        # Deleting model 'Film'
        db.delete_table('core_film')

        # Deleting model 'Cinema'
        db.delete_table('core_cinema')

        # Deleting model 'Psitopoleio'
        db.delete_table('core_psitopoleio')
    
    
    models = {
        'core.cinema': {
            'Meta': {'object_name': 'Cinema'},
            'film': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Film']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'region': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Region']"})
        },
        'core.film': {
            'Meta': {'object_name': 'Film'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '128'})
        },
        'core.psitopoleio': {
            'Meta': {'object_name': 'Psitopoleio'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'rating': ('django.db.models.fields.IntegerField', [], {'default': '2'}),
            'region': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Region']"})
        },
        'core.region': {
            'Meta': {'object_name': 'Region'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '128'})
        }
    }
    
    complete_apps = ['core']
