from django.db import models

class Region(models.Model):
    name = models.CharField(max_length=128)
    def __unicode__(self):
        return self.name


class Film(models.Model):
    name = models.CharField(max_length=128)
    def __unicode__(self):
        return self.name


class Cinema(models.Model):
    name = models.CharField(max_length=128)
    region = models.ForeignKey(Region)
    film = models.ForeignKey(Film)
    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name = "Cinemas"
        verbose_name_plural = "Cinemades"


class Psitopoleio(models.Model):
    name = models.CharField(max_length=128)
    rating = models.IntegerField(default=2)
    region = models.ForeignKey(Region)
    def asterakia(self):
        return self.rating*'* '
    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name = "Psitopoleio"
        verbose_name_plural = "Psitopoleia"

