from django.shortcuts import render_to_response, get_object_or_404
from django.views.generic import list_detail

from kozanorama.core.models import *
from kozanorama.core.decorators import *

def cinema_detail(request, *args, **kwargs):
    cinema = get_object_or_404(Cinema, pk=kwargs["object_id"])
    pshtopoleia_sthn_perioxh = \
        Psitopoleio.objects.filter(region__id=cinema.region.id).order_by('-rating')
    kwargs["request"] = request
    kwargs["template_name"] = "cinema_detail.html"
    kwargs["extra_context"] = {"pshtopoleia_sthn_perioxh":pshtopoleia_sthn_perioxh, }
    return list_detail.object_detail(*args, **kwargs)


def psitopoleio_detail(request, *args, **kwargs):
    psitopoleio = get_object_or_404(Psitopoleio, pk=kwargs["object_id"])
    cinemades_sthn_perioxh = \
        Cinema.objects.filter(region__id=psitopoleio.region.id).order_by('film__name')
    kwargs["request"] = request
    kwargs["template_name"] = "psitopoleio_detail.html"
    kwargs["extra_context"] = {"cinemades_sthn_perioxh":cinemades_sthn_perioxh, }
    return list_detail.object_detail(*args, **kwargs)


@sort_by
@filter_by
def cinema_list(request, queryset, *args, **kwargs):
    kwargs["template_name"] = "cinema_list.html"
    queryset = queryset
    return list_detail.object_list(request,queryset=queryset, *args, **kwargs )


@sort_by
@filter_by
def psitopoleio_list(request, queryset, *args, **kwargs):
    kwargs["template_name"] = "psitopoleio_list.html"
    queryset = queryset
    return list_detail.object_list(request,queryset=queryset, *args, **kwargs )


