from django.conf.urls.defaults import *
from django.conf import settings
from kozanorama.core.models import *
from kozanorama.core import views

from django.contrib import admin
admin.autodiscover()

cinemas = {'queryset': Cinema.objects.all(),
            'template_object_name': 'cinema',}
psitopoleia = {'queryset': Psitopoleio.objects.all(),
            'template_object_name': 'psitopoleio',}

urlpatterns = patterns('',
    (r'^$', 'django.views.generic.simple.direct_to_template', {'template': 'index.html'}), 
    (r'^cinemas/$',
     views.cinema_list, cinemas, 'cinema_list'),
    (r'^psitopoleia/$',
     views.psitopoleio_list, psitopoleia, 'psitopoleio_list'),
    (r'^cinemas/(?P<object_id>\d+)/$',
     views.cinema_detail, cinemas, 'cinema_detail'),
    (r'^psitopoleia/(?P<object_id>\d+)/$',
     views.psitopoleio_detail, psitopoleia, 'psitopoleio_detail'),

    (r'^admin/', include(admin.site.urls)),
)

urlpatterns += patterns('',
    (r'^site_media/(?P<path>.*)$', 'django.views.static.serve',
     {'document_root': settings.MEDIA_ROOT}),
)
